function [f,Data]=STM32F103_CC_GET(skt)
 if (size(findname(skt.name,"CC_Fest"))>0)
   f=udpget(skt,"CC_Fest");
   if (min(size(f))<1)
    size(f)
    f=udpget(skt,"CC_Fest");
   end
  else

   d1=udpget(skt,"DMA1_C7_CNDTR");
   d2=udpget(skt,"DMA1_C7_CNDTR");
   d3=udpget(skt,"DMA1_C7_CNDTR");
   if (d1 -[d2 d3] ==0)
     Data=0;
     f=0;
     return
   else
     dt=1/udpget(skt,"SystemCoreClock");
     Data=udpget(skt,'CC_DMA_Buffer');
     Times=udpgettconv(Data,2,1); % 0 is uint8  2 is uint16
     dTimes=diff(Times);

     mt=median(dTimes);

     idx=find(dTimes<1.2*mt);
     dTimes=dTimes(idx);
     idx=find(dTimes>0.75*mt);
     dTimes=dTimes(idx);

     dTimes=dTimes*dt/8;
     f=1/mean(dTimes);
   end
 end
endfunction


